/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.blockswap.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.blockswap.BlockSwap;
import corgitaco.blockswap.shadow.blue.endless.jankson.api.SyntaxError;
import corgitaco.blockswap.util.CodecUtil;
import corgitaco.blockswap.util.CommentedCodec;
import corgitaco.blockswap.util.jankson.JanksonJsonOps;
import corgitaco.blockswap.util.jankson.JanksonUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_7923;

public record BlockSwapConfig(Map<class_2248, class_2248> blockBlockMap, Map<class_2680, class_2680> blockStateBlockStateMap, boolean retroGen, boolean generateAllKnownStates) {
    public static final BlockSwapConfig DEFAULT = new BlockSwapConfig(new IdentityHashMap<class_2248, class_2248>(), new IdentityHashMap<class_2680, class_2680>(), false, true);
    private static final String SWAPPER_EXAMPLE = "\t\"swapper\": {\n\t\t\"minecraft:coarse_dirt\": \"minecraft:dirt\",\n\t\t\"minecraft:diamond_block\": \"minecraft:emerald_block\"\n\t}\n";
    private static final String STATE_SWAPPER_EXAMPLE = " \"state_swapper\": [\n \t{\n \t\t\"new\": {\n \t\t\t\"Name\": \"minecraft:birch_log\",\n \t\t\t// Properties define the state of this block/fluid.\n \t\t\t\"Properties\": {\n \t\t\t\t\"axis\": \"x\"\n \t\t\t}\n \t\t},\n \t\t\"old\": {\n \t\t\t\"Name\": \"minecraft:oak_log\",\n \t\t\t// Properties define the state of this block/fluid.\n \t\t\t\"Properties\": {\n \t\t\t\t\"axis\": \"z\"\n \t\t\t}\n \t\t}\n \t},\n \t{\n \t\t\"new\": {\n \t\t\t\"Name\": \"minecraft:birch_leaves\",\n \t\t\t// Properties define the state of this block/fluid.\n \t\t\t\"Properties\": {\n \t\t\t\t\"distance\": \"7\",\n \t\t\t\t\"persistent\": \"true\"\n \t\t\t}\n \t\t},\n \t\t\"old\": {\n \t\t\t\"Name\": \"minecraft:acacia_log\",\n \t\t\t// Properties define the state of this block/fluid.\n \t\t\t\"Properties\": {\n \t\t\t\t\"axis\": \"z\"\n \t\t\t}\n \t\t}\n \t},\n \t{\n \t\t\"new\": {\n \t\t\t\"Name\": \"minecraft:jungle_log\",\n \t\t\t// Properties define the state of this block/fluid.\n \t\t\t\"Properties\": {\n \t\t\t\t\"axis\": \"x\"\n \t\t\t}\n \t\t},\n \t\t\"old\": {\n \t\t\t\"Name\": \"minecraft:birch_log\",\n \t\t\t// Properties define the state of this block/fluid.\n \t\t\t\"Properties\": {\n \t\t\t\t\"axis\": \"z\"\n \t\t\t}\n \t\t}\n \t},\n \t{\n \t\t\"new\": {\n \t\t\t\"Name\": \"minecraft:jungle_planks\",\n \t\t},\n \t\t\"old\": {\n \t\t\t\"Name\": \"minecraft:acacia_planks\",\n \t\t\t}\n \t\t}\n \t}\n ]\n";
    private static final Codec<BlockSwapConfig> RAW_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CommentedCodec.of(Codec.unboundedMap(CodecUtil.BLOCK_CODEC, CodecUtil.BLOCK_CODEC), "swapper", "A map of blocks that specifies what the \"old\" block is and what its \"new\" block is.\nExample:\n\t\"swapper\": {\n\t\t\"minecraft:coarse_dirt\": \"minecraft:dirt\",\n\t\t\"minecraft:diamond_block\": \"minecraft:emerald_block\"\n\t}\n").forGetter(BlockSwapConfig::blockBlockMap), (App)CommentedCodec.of(CodecUtil.KEYABLE_BLOCKSTATE_CODEC, "state_swapper", "A map of states that specifies what the \"old\" block state is and what its \"new\" block state is.\nSee \"known_states\" folder(\"generate_all_known_states\" must be set to true in this config) to see all known block states available for all blocks available in the registry.\nExample:\n \"state_swapper\": [\n \t{\n \t\t\"new\": {\n \t\t\t\"Name\": \"minecraft:birch_log\",\n \t\t\t// Properties define the state of this block/fluid.\n \t\t\t\"Properties\": {\n \t\t\t\t\"axis\": \"x\"\n \t\t\t}\n \t\t},\n \t\t\"old\": {\n \t\t\t\"Name\": \"minecraft:oak_log\",\n \t\t\t// Properties define the state of this block/fluid.\n \t\t\t\"Properties\": {\n \t\t\t\t\"axis\": \"z\"\n \t\t\t}\n \t\t}\n \t},\n \t{\n \t\t\"new\": {\n \t\t\t\"Name\": \"minecraft:birch_leaves\",\n \t\t\t// Properties define the state of this block/fluid.\n \t\t\t\"Properties\": {\n \t\t\t\t\"distance\": \"7\",\n \t\t\t\t\"persistent\": \"true\"\n \t\t\t}\n \t\t},\n \t\t\"old\": {\n \t\t\t\"Name\": \"minecraft:acacia_log\",\n \t\t\t// Properties define the state of this block/fluid.\n \t\t\t\"Properties\": {\n \t\t\t\t\"axis\": \"z\"\n \t\t\t}\n \t\t}\n \t},\n \t{\n \t\t\"new\": {\n \t\t\t\"Name\": \"minecraft:jungle_log\",\n \t\t\t// Properties define the state of this block/fluid.\n \t\t\t\"Properties\": {\n \t\t\t\t\"axis\": \"x\"\n \t\t\t}\n \t\t},\n \t\t\"old\": {\n \t\t\t\"Name\": \"minecraft:birch_log\",\n \t\t\t// Properties define the state of this block/fluid.\n \t\t\t\"Properties\": {\n \t\t\t\t\"axis\": \"z\"\n \t\t\t}\n \t\t}\n \t},\n \t{\n \t\t\"new\": {\n \t\t\t\"Name\": \"minecraft:jungle_planks\",\n \t\t},\n \t\t\"old\": {\n \t\t\t\"Name\": \"minecraft:acacia_planks\",\n \t\t\t}\n \t\t}\n \t}\n ]\n").forGetter(BlockSwapConfig::blockStateBlockStateMap), (App)CommentedCodec.of(Codec.BOOL, "retro_gen", "Whether blocks are replaced in existing chunks.").forGetter(BlockSwapConfig::retroGen), (App)CommentedCodec.of(Codec.BOOL, "generate_all_known_states", "Generates all block states for all blocks in the registry.").forGetter(BlockSwapConfig::generateAllKnownStates)).apply((Applicative)builder, BlockSwapConfig::new));
    public static final Codec<BlockSwapConfig> CODEC = RAW_CODEC.flatXmap(BlockSwapConfig.verifyConfig(), BlockSwapConfig.verifyConfig());
    private static BlockSwapConfig CONFIG = null;

    public boolean contains(class_2680 state) {
        return this.blockBlockMap.containsKey(state.method_26204()) || this.blockStateBlockStateMap.containsKey(state);
    }

    private static Function<BlockSwapConfig, DataResult<BlockSwapConfig>> verifyConfig() {
        return blockSwapConfig -> {
            void var3_9;
            StringBuilder blockSwapperErrors = new StringBuilder();
            for (class_2248 class_22482 : blockSwapConfig.blockBlockMap.values()) {
                if (!blockSwapConfig.blockBlockMap.containsKey(class_22482)) continue;
                blockSwapperErrors.append(class_7923.field_41175.method_10221((Object)class_22482)).append("\n");
            }
            StringBuilder stateSwapperErrors = new StringBuilder();
            for (class_2680 value : blockSwapConfig.blockStateBlockStateMap.values()) {
                if (!blockSwapConfig.blockStateBlockStateMap.containsKey(value)) continue;
                stateSwapperErrors.append(value.toString()).append("\n");
            }
            String string = "";
            if (!blockSwapperErrors.isEmpty()) {
                String string2 = string + String.format("Detected circular BLOCK reference(s) in the \"swapper\"! Blocks being swapped cannot be used as a block to swap into. Circular references found:\n%s\n", blockSwapperErrors);
            }
            if (!stateSwapperErrors.isEmpty()) {
                void var3_7;
                String string3 = (String)var3_7 + String.format("Detected circular BLOCKSTATE reference(s) in the \"state_swapper\"! BlockStates being swapped cannot be used as a BlockState to swap into. Circular references found:\n%s", stateSwapperErrors);
            }
            if (!var3_9.isEmpty()) {
                void finalErrorMessage = var3_9;
                return DataResult.error(() -> BlockSwapConfig.lambda$verifyConfig$1((String)finalErrorMessage));
            }
            return DataResult.success((Object)blockSwapConfig);
        };
    }

    public static BlockSwapConfig getConfig(BlockSwapConfig server) {
        CONFIG = server;
        return CONFIG;
    }

    public static BlockSwapConfig getConfig(boolean reload) {
        if (CONFIG == null || reload) {
            Path path = BlockSwap.CONFIG_PATH.resolve("block_swap.json5");
            File configFile = path.toFile();
            try {
                if (!configFile.exists()) {
                    JanksonUtil.createConfig(path, CODEC, "/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/", (Map<String, String>)new Object2ObjectOpenHashMap(), JanksonJsonOps.INSTANCE, DEFAULT);
                }
                CONFIG = JanksonUtil.readConfig(path, CODEC, JanksonJsonOps.INSTANCE);
            }
            catch (SyntaxError | IOException e) {
                e.printStackTrace();
            }
        }
        return CONFIG;
    }
}

